/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.json;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DummyJSONSerializer {
    private static boolean doFormat = false;
    private static int level = 0;
    private static int tabs = 2;
    private static final String escape3Text = "\"\\/\b\f\n\r\t";
    private static final Pattern escape3Pattern = Pattern.compile("[\"\\\\/\b\f\n\r\t\u0000-\u001f]");
    private static final String[] escape3Replacement = new String[]{"\\\\\"", "\\\\\\\\", "\\\\/", "\\\\b", "\\\\f", "\\\\n", "\\\\r", "\\\\t"};

    private static void formatEnter(StringBuffer sb) {
        if (!doFormat) {
            return;
        }
        ++level;
    }

    private static void formatMid(StringBuffer sb) {
        if (!doFormat) {
            return;
        }
        sb.append("\n");
        for (int i = 0; i < tabs * level; ++i) {
            sb.append(" ");
        }
    }

    private static void formatLeave(StringBuffer sb) {
        if (!doFormat) {
            return;
        }
        --level;
    }

    private static boolean fieldFilter(Field field) {
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        return !"hash".equals(field.getName()) || !"java.lang.String".equals(field.getDeclaringClass().getName());
    }

    private static String serializeEnum(Enum e) {
        return "\"" + e.name() + "\"";
    }

    private static boolean isNumberOrBoolean(Object o) {
        return o instanceof Number || o instanceof Boolean;
    }

    private static String serializeNumberOrBoolean(Object o) {
        return o.toString();
    }

    private static String serializeString(String o) {
        Matcher m = escape3Pattern.matcher(o);
        StringBuffer sb = new StringBuffer((int)((float)o.length() * 1.1f) + 2);
        sb.append('\"');
        while (m.find()) {
            char c = m.group().charAt(0);
            int index = escape3Text.indexOf(c);
            m.appendReplacement(sb, index >= 0 ? escape3Replacement[index] : String.format("\\\\u%04x", c));
        }
        m.appendTail(sb);
        sb.append('\"');
        return sb.toString();
    }

    private static String serializeMap(Map m) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        DummyJSONSerializer.formatEnter(sb);
        int count = 0;
        for (Object key : m.keySet()) {
            if (count > 0) {
                sb.append(",");
            }
            DummyJSONSerializer.formatMid(sb);
            ++count;
            sb.append(DummyJSONSerializer.serialize(key)).append(":").append(DummyJSONSerializer.serialize(m.get(key)));
        }
        sb.append("}");
        DummyJSONSerializer.formatLeave(sb);
        return sb.toString();
    }

    private static String serializeCollection(Collection c) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        DummyJSONSerializer.formatEnter(sb);
        int count = 0;
        for (Object o : c) {
            if (count > 0) {
                sb.append(",");
            }
            DummyJSONSerializer.formatMid(sb);
            ++count;
            sb.append(DummyJSONSerializer.serialize(o));
        }
        sb.append("]");
        DummyJSONSerializer.formatLeave(sb);
        return sb.toString();
    }

    private static String printFieldName(Field field) {
        String name = field.getName();
        if (name.equals("interfaceName") && "com.azul.crs.client.Inventory$Network".equals(field.getDeclaringClass().getName())) {
            name = "interface";
        }
        return DummyJSONSerializer.serializeString(name);
    }

    private static String serializeObject(Object o) {
        if (null == o) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        DummyJSONSerializer.formatEnter(sb);
        Class<?> oc = o.getClass();
        int count = 0;
        for (Field field : oc.getDeclaredFields()) {
            if (!DummyJSONSerializer.fieldFilter(field)) continue;
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(o);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException("Tykwa: ", e);
            }
            if (value == null) continue;
            if (count > 0) {
                sb.append(",");
            }
            DummyJSONSerializer.formatMid(sb);
            sb.append(DummyJSONSerializer.printFieldName(field)).append(":").append(DummyJSONSerializer.serialize(value));
            ++count;
        }
        sb.append("}");
        DummyJSONSerializer.formatLeave(sb);
        return sb.toString();
    }

    public static String serialize(Object o) {
        if (o instanceof String) {
            return DummyJSONSerializer.serializeString((String)o);
        }
        if (o instanceof Enum) {
            return DummyJSONSerializer.serializeEnum((Enum)o);
        }
        if (DummyJSONSerializer.isNumberOrBoolean(o)) {
            return DummyJSONSerializer.serializeNumberOrBoolean(o);
        }
        if (o instanceof Map) {
            return DummyJSONSerializer.serializeMap((Map)o);
        }
        if (o instanceof Collection) {
            return DummyJSONSerializer.serializeCollection((Collection)o);
        }
        return DummyJSONSerializer.serializeObject(o);
    }
}

