/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.Client;
import com.azul.crs.shared.Utils;
import com.azul.crs.util.logging.Logger;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Inventory {
    public static final String INSTANCE_TAGS_PROPERTY = "com.azul.crs.instance.tags";
    public static final String HOST_NAME_KEY = "hostName";
    public static final String NETWORKS_KEY = "networks";
    public static final String SYSTEM_PROPS_KEY = "systemProperties";
    public static final String JVM_ARGS_KEY = "jvmArgs";
    public static final String MAIN_METHOD = "mainMethod";
    public static final String ENVIRONMENT_KEY = "osEnvironment";
    private Logger logger = Logger.getLogger(Inventory.class);
    private Map<String, Object> map = new LinkedHashMap<String, Object>();

    public Inventory populate() {
        this.map.put(HOST_NAME_KEY, this.hostName());
        this.map.put(SYSTEM_PROPS_KEY, this.systemProperties());
        this.map.put(JVM_ARGS_KEY, Inventory.jvmArgs());
        this.map.put(ENVIRONMENT_KEY, this.osEnvironment());
        return this;
    }

    public Inventory networkInformation() {
        this.map.put(NETWORKS_KEY, this.networks());
        return this;
    }

    public Inventory mainMethod(String mainMethod) {
        this.map.put(MAIN_METHOD, mainMethod);
        return this;
    }

    public String hostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            this.logger.warning("cannot get host name %s", uhe.toString());
            String name = this.getHostNameViaReflection();
            if (name == null) {
                name = this.getHostNameFromNetworkInterface();
            }
            if (name == null) {
                name = "<UNKNOWN>";
            }
            return name;
        }
    }

    public static String instanceTags() {
        return System.getProperties().getProperty(INSTANCE_TAGS_PROPERTY);
    }

    public Map systemProperties() {
        return System.getProperties();
    }

    public Map<String, String> osEnvironment() {
        return System.getenv();
    }

    public static List<String> jvmArgs() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getInputArguments();
    }

    private List<Network> networks() {
        try {
            ArrayList<Network> result = new ArrayList<Network>();
            for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                try {
                    if (!ni.isUp() || ni.isLoopback() || ni.getName().startsWith("docker")) continue;
                    ArrayList<Address> addrList = new ArrayList<Address>();
                    for (InetAddress addr : Collections.list(ni.getInetAddresses())) {
                        if (Client.isVMShutdownInitiated() && Utils.currentTimeCount() >= Client.getVMShutdownDeadline()) {
                            return Collections.emptyList();
                        }
                        addrList.add(new Address(addr.getCanonicalHostName(), this.getTrueIpAddress(addr)));
                    }
                    addrList.sort(Comparator.comparing(new Function<Address, String>(){

                        @Override
                        public String apply(Address a) {
                            return a.hostname;
                        }
                    }));
                    result.add(new Network(ni.getName(), addrList));
                }
                catch (SocketException e) {
                    this.logger.warning("cannot get network info %s", e.toString());
                }
            }
            result.sort(Comparator.comparing(new Function<Network, String>(){

                @Override
                public String apply(Network ni) {
                    return ni.interfaceName;
                }
            }));
            return result;
        }
        catch (SocketException e) {
            this.logger.warning("cannot get network info %s", e.toString());
            return Collections.emptyList();
        }
    }

    private String getTrueIpAddress(InetAddress addr) {
        String text = addr.getHostAddress();
        int pos = text.indexOf(37);
        return pos < 0 ? text : text.substring(0, pos);
    }

    Map<String, Object> toMap() {
        return this.map;
    }

    private String getHostNameViaReflection() {
        try {
            Class<?> clazz = Class.forName("java.net.Inet4AddressImpl");
            Method method = clazz.getDeclaredMethod("getLocalHostName", new Class[0]);
            method.setAccessible(true);
            for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
                if (ctor.getParameterCount() != 0) continue;
                ctor.setAccessible(true);
                Object instance = ctor.newInstance(new Object[0]);
                Object result = method.invoke(instance, new Object[0]);
                if (result instanceof String) {
                    return (String)result;
                }
                this.logger.warning("cannot get host name. internal error %s", result == null ? null : result.getClass());
                return null;
            }
        }
        catch (ReflectiveOperationException | SecurityException e) {
            this.logger.warning("cannot get host name %s", e.toString());
        }
        return null;
    }

    private String getHostNameFromNetworkInterface() {
        try {
            String candidateName = null;
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                Enumeration<InetAddress> isa = ni.getInetAddresses();
                while (isa.hasMoreElements()) {
                    InetAddress ia = isa.nextElement();
                    if (ia instanceof Inet4Address) {
                        return ia.getCanonicalHostName();
                    }
                    candidateName = ia.getCanonicalHostName();
                }
            }
            return candidateName;
        }
        catch (SocketException e) {
            this.logger.warning("cannot get host name for iface %s", e.toString());
            return null;
        }
    }

    private static class Address {
        public final String hostname;
        public final String address;

        public Address(String hostname, String address) {
            this.hostname = hostname;
            this.address = address;
        }
    }

    private static class Network {
        public final String interfaceName;
        public final List<Address> addresses;

        public Network(String interfaceName, List<Address> addresses) {
            this.interfaceName = interfaceName;
            this.addresses = addresses;
        }
    }
}

