/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.CRSException;
import com.azul.crs.client.Client;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Response;
import com.azul.crs.client.Result;
import com.azul.crs.shared.Utils;
import com.azul.crs.shared.models.Payload;
import com.azul.crs.shared.models.VMArtifactChunk;
import com.azul.crs.shared.models.VMEvent;
import com.azul.crs.util.logging.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ConnectionManager {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final Class<Payload> VOID = null;
    private static final String AUTH_TOKEN_RESOURCE = "/crs/auth/rt/token";
    private static final String EVENT_RESOURCE = "/crs/instance/{vmId}";
    private static final String ARTIFACT_CHUNK_RESOURCE = "/crs/artifact/chunk";
    private static final String MEDIA_TYPE_TEXT_PLAIN = "text/plain";
    private static final String MEDIA_TYPE_JSON = "application/json";
    private static final String MEDIA_TYPE_BINARY = "application/octet-stream";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_STREAM_LENGTH = "Stream-Length";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_PATCH = "PATCH";
    private static final int MAX_RETRIES = 3;
    private static final long RETRY_SLEEP = 100L;
    private static final String YEK_IPA = "r1fhe2lVGN1EgDHH0Eg8d94tjv12e0F7a78RNysB";
    private final Logger logger = Logger.getLogger(ConnectionManager.class);
    private final String restAPI;
    private final String mailbox;
    private final ConnectionListener listener;
    private static final long TOKEN_REFRESH_TIMEOUT_MS = 300000L;
    private final Client client;
    private final String keystore;
    private String runtimeToken;
    private long nextRuntimeTokenRefreshTimeCount;
    private String vmId;
    private boolean unrecoverableError;
    private SSLSocketFactory sslSocketFactoryOne;
    private SSLSocketFactory sslSocketFactoryTwo;
    private static final ConnectionConsumer NONE = new ConnectionConsumer(){

        @Override
        public void consume(HttpsURLConnection con) throws IOException {
        }
    };

    ConnectionManager(Map<Client.ClientProp, Object> props, Client client, ConnectionListener listener) {
        this.client = client;
        this.listener = listener;
        this.restAPI = (String)props.get((Object)Client.ClientProp.API_URL);
        this.mailbox = (String)props.get((Object)Client.ClientProp.API_MAILBOX);
        this.keystore = (String)props.get((Object)Client.ClientProp.KS);
        this.logger.info("Using CRS endpoint configuration\n   API url = %s\n   mailbox = %s", this.restAPI, this.mailbox);
        if (this.keystore != null) {
            this.logger.info("   auth override keystore = %s", this.keystore);
        }
    }

    void start() throws IOException {
        this.createCustomTrustManagers();
        this.saveRuntimeToken(this.getRuntimeToken(this.client.getClientVersion(), this.mailbox));
    }

    private void saveRuntimeToken(String[] token) {
        if (token.length == 2) {
            this.runtimeToken = token[0];
            this.vmId = token[1];
            this.listener.authenticated();
        } else {
            this.listener.syncFailed(new Result<String[]>(new IOException("Protocol failure, wrong auth response")));
        }
    }

    private X509TrustManager getX509TrustManager(KeyStore ks) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmFactory.init(ks);
        for (TrustManager tm : tmFactory.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        throw new NoSuchAlgorithmException();
    }

    private void createCustomTrustManagers() throws CRSException {
        try {
            char[] password = "crscrs".toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            try (InputStream keystoreStream = this.keystore == null ? this.getClass().getResourceAsStream("crs.jks") : new FileInputStream(this.keystore);){
                ks.load(keystoreStream, password);
            }
            KeyManagerFactory kmFactory = KeyManagerFactory.getInstance("NewSunX509");
            kmFactory.init(ks, password);
            final X509TrustManager tmOne = this.getX509TrustManager(ks);
            final X509TrustManager tmDefault = this.getX509TrustManager(null);
            int icount1 = tmOne.getAcceptedIssuers().length;
            int icount2 = tmDefault.getAcceptedIssuers().length;
            final X509Certificate[] allIssuers = new X509Certificate[icount1 + icount2];
            System.arraycopy(tmOne.getAcceptedIssuers(), 0, allIssuers, 0, icount1);
            System.arraycopy(tmDefault.getAcceptedIssuers(), 0, allIssuers, icount1, icount2);
            X509TrustManager tmTwo = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    throw new CertificateException("unsupported operation");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    try {
                        tmOne.checkServerTrusted(chain, authType);
                    }
                    catch (CertificateException ignored) {
                        tmDefault.checkServerTrusted(chain, authType);
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return allIssuers;
                }
            };
            KeyManager[] keyManagers = kmFactory.getKeyManagers();
            this.sslSocketFactoryOne = this.createSocketFactory(tmOne, keyManagers);
            this.sslSocketFactoryTwo = this.createSocketFactory(tmTwo, keyManagers);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            this.unrecoverableError = true;
            throw new CRSException(-4, "Unrecoverable internal error: ", ex);
        }
    }

    private SSLSocketFactory createSocketFactory(X509TrustManager tm, KeyManager[] keyManagers) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, new TrustManager[]{tm}, null);
        return sslContext.getSocketFactory();
    }

    private HttpsURLConnection createConnection(String url) throws IOException {
        if (this.unrecoverableError) {
            throw new IOException("Unrecoverable error");
        }
        URL endpoint = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)endpoint.openConnection();
        con.setUseCaches(false);
        con.setConnectTimeout(30000);
        con.setReadTimeout(20000);
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestProperty(HEADER_CONTENT_TYPE, MEDIA_TYPE_JSON);
        con.setRequestProperty(HEADER_ACCEPT, MEDIA_TYPE_TEXT_PLAIN);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response<String[]> requestAny(String resource, String method, ConnectionConsumer headerWriter, ConnectionConsumer requestWriter) throws IOException {
        long startTime = Utils.currentTimeCount();
        Response<String[]> response = new Response<String[]>();
        HttpsURLConnection con = this.createConnection(resource);
        con.setSSLSocketFactory(this.sslSocketFactoryOne);
        if (method.equals(METHOD_PATCH)) {
            con.setRequestProperty("X-HTTP-Method-Override", method);
            method = METHOD_POST;
        }
        con.setRequestProperty(HEADER_AUTHORIZATION, "Bearer " + this.runtimeToken);
        con.setRequestMethod(method);
        headerWriter.consume(con);
        con.connect();
        PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(startTime));
        try {
            requestWriter.consume(con);
            int code = con.getResponseCode();
            String message = con.getResponseMessage();
            response.code(code);
            response.message(message);
            this.logger.debug("requestAny response code %d", code);
            if (code < 200 || code >= 300) {
                if (code == 401 && Utils.currentTimeCount() > this.nextRuntimeTokenRefreshTimeCount) {
                    this.saveRuntimeToken(this.refreshRuntimeToken(this.runtimeToken));
                    Response<String[]> response2 = this.requestAny(resource, method, headerWriter, requestWriter);
                    return response2;
                }
                if (con.getErrorStream() != null) {
                    response.error(this.readStream(con.getErrorStream()));
                }
            } else {
                response.payload(this.readStreamToArray(con.getInputStream()));
            }
        }
        finally {
            PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(startTime));
            con.disconnect();
        }
        return response;
    }

    public Response<String[]> sendVMEventBatch(Collection<VMEvent> events) throws IOException {
        return this.requestAnyJson(this.restAPI + EVENT_RESOURCE.replace("{vmId}", this.vmId), METHOD_POST, Payload.toJsonArray(events));
    }

    public void requestWithRetries(ResponseSupplier request, String requestName, int maxRetries, long retrySleep) {
        Result<String[]> result = this.requestWithRetriesImpl(request, requestName, maxRetries, retrySleep);
        if (!result.successful()) {
            this.listener.syncFailed(result);
        }
    }

    private Result<String[]> requestWithRetriesImpl(ResponseSupplier request, String requestName, int maxRetries, long retrySleep) {
        Result<Object> result;
        int attempt = 1;
        long startTime = Utils.currentTimeCount();
        while (true) {
            try {
                result = new Result<String[]>(request.get());
                if (result.successful()) {
                    this.logger.debug("Request %s succeeded on attempt %d, elapsed%s", requestName, attempt, Utils.elapsedTimeString(startTime));
                    return result;
                }
            }
            catch (IOException ioe) {
                this.logger.debug("Request %s failed on attempt %s of %s, elapsed%s: %s", requestName, attempt, maxRetries, Utils.elapsedTimeString(startTime), ioe.toString());
                result = new Result(ioe);
            }
            if (!result.canRetry() || ++attempt > maxRetries) break;
            Utils.sleep(retrySleep);
        }
        this.logger.debug("Request %s aborted after %d attempt, elapsed%s", requestName, attempt, Utils.elapsedTimeString(startTime));
        return result;
    }

    Response<String[]> requestAnyJson(final String resource, final String method, final String payload) throws IOException {
        return this.requestAny(resource, method, NONE, new ConnectionConsumer(){

            @Override
            public void consume(HttpsURLConnection con) throws IOException {
                ConnectionManager.this.logger.debug("%s %s\n", method, resource);
                ConnectionManager.this.logger.trace("%s\n\n", payload);
                ConnectionManager.this.writeData(con, payload.getBytes(UTF_8));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        long totalLength = 0L;
        byte[] readBuffer = new byte[1024];
        try {
            int length;
            while ((length = inputStream.read(readBuffer)) != -1) {
                outputStream.write(readBuffer, 0, length);
                totalLength += (long)length;
            }
        }
        finally {
            PerformanceMetrics.logBytes(totalLength, 0L);
        }
        return outputStream.toString(UTF_8);
    }

    private String[] readStreamToArray(InputStream is) throws IOException {
        String s;
        LinkedList<String> result = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((s = reader.readLine()) != null) {
            result.add(s);
        }
        return result.toArray(new String[0]);
    }

    private void writeData(URLConnection con, byte[] data, int size) throws IOException {
        try (OutputStream out = con.getOutputStream();){
            out.write(data, 0, size);
            PerformanceMetrics.logBytes(0L, size);
        }
    }

    private void writeData(URLConnection con, byte[] data) throws IOException {
        this.writeData(con, data, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeData(URLConnection con, InputStream in) throws IOException {
        long written = 0L;
        try (OutputStream out = con.getOutputStream();){
            int length;
            byte[] buf = new byte[1024];
            while ((length = in.read(buf)) > 0) {
                out.write(buf, 0, length);
                written += (long)length;
            }
        }
        finally {
            PerformanceMetrics.logBytes(0L, written);
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response putBinaryData(String location, ConnectionConsumer requestWriter) throws IOException {
        long startTime = Utils.currentTimeCount();
        Response response = new Response();
        HttpsURLConnection con = this.createConnection(location);
        con.setSSLSocketFactory(this.sslSocketFactoryTwo);
        con.setRequestProperty(HEADER_CONTENT_TYPE, MEDIA_TYPE_BINARY);
        con.setRequestMethod(METHOD_PUT);
        con.connect();
        PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(startTime));
        try {
            requestWriter.consume(con);
            response.code(con.getResponseCode());
            response.message(con.getResponseMessage());
            if (!response.successful()) {
                response.error(this.readStream(con.getErrorStream()));
            }
        }
        finally {
            PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(startTime));
            con.disconnect();
        }
        return response;
    }

    private Response putBinaryData(String location, final InputStream is) throws IOException {
        return this.putBinaryData(location, new ConnectionConsumer(){

            @Override
            public void consume(HttpsURLConnection con) throws IOException {
                ConnectionManager.this.writeData(con, is);
            }
        });
    }

    public Response<String[]> sendVMArtifactChunk(VMArtifactChunk chunk, InputStream is) throws IOException {
        String[] created;
        String location;
        Response uploadResponse;
        Response<String[]> createResponse = this.requestAnyJson(this.restAPI + ARTIFACT_CHUNK_RESOURCE, METHOD_POST, chunk.toJson());
        if (createResponse.successful() && is != null && !(uploadResponse = this.putBinaryData(location = (created = createResponse.getPayload())[0], is)).successful()) {
            throw new IOException("Created VM artifact chunk failed to upload data: chunkId=" + created[1] + ", error=" + uploadResponse.getError());
        }
        return createResponse;
    }

    private Response<String[]> retrieveRuntimeToken(HttpsURLConnection con) throws IOException {
        Response<String[]> response = new Response().code(con.getResponseCode()).message(con.getResponseMessage());
        if (!response.successful()) {
            if (con.getErrorStream() != null) {
                response.error(this.readStream(con.getErrorStream()));
            }
            return response;
        }
        return response.payload(this.readStreamToArray(con.getInputStream()));
    }

    private String[] getRuntimeToken(final String clientVersion, final String mailbox) throws CRSException {
        this.logger.info("Get runtime token: clientVersion=%s, mailbox=%s", clientVersion, mailbox);
        final long startTime = Utils.currentTimeCount();
        this.nextRuntimeTokenRefreshTimeCount = Utils.nextTimeCount(300000L);
        Result<String[]> result = this.requestWithRetriesImpl(new ResponseSupplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response<String[]> get() throws IOException {
                long attemptStartTime = Utils.currentTimeCount();
                HttpsURLConnection con = ConnectionManager.this.createConnection(ConnectionManager.this.restAPI + ConnectionManager.AUTH_TOKEN_RESOURCE + "?clientVersion=" + clientVersion + "&mailbox=" + mailbox);
                con.setSSLSocketFactory(ConnectionManager.this.sslSocketFactoryOne);
                con.setRequestProperty("x-api-key", ConnectionManager.YEK_IPA);
                con.setRequestMethod(ConnectionManager.METHOD_GET);
                con.connect();
                PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(attemptStartTime));
                try {
                    Response response = ConnectionManager.this.retrieveRuntimeToken(con);
                    return response;
                }
                finally {
                    PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(startTime));
                    con.disconnect();
                }
            }
        }, "getRuntimeToken", 3, 100L);
        if (!result.successful()) {
            throw new CRSException(this.client, -2, "Cannot get runtime token: ", result);
        }
        return result.getResponse().getPayload();
    }

    private String[] refreshRuntimeToken(final String runtimeToken) throws IOException {
        final long startTime = Utils.currentTimeCount();
        this.nextRuntimeTokenRefreshTimeCount = Utils.nextTimeCount(300000L);
        this.logger.info("Refresh runtime token", new Object[0]);
        Result<String[]> result = this.requestWithRetriesImpl(new ResponseSupplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response<String[]> get() throws IOException {
                long attemptStartTime = Utils.currentTimeCount();
                HttpsURLConnection con = ConnectionManager.this.createConnection(ConnectionManager.this.restAPI + ConnectionManager.AUTH_TOKEN_RESOURCE);
                con.setSSLSocketFactory(ConnectionManager.this.sslSocketFactoryOne);
                con.setRequestProperty("x-api-key", ConnectionManager.YEK_IPA);
                con.setRequestProperty(ConnectionManager.HEADER_CONTENT_TYPE, ConnectionManager.MEDIA_TYPE_TEXT_PLAIN);
                con.setRequestMethod(ConnectionManager.METHOD_POST);
                con.connect();
                PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(attemptStartTime));
                try {
                    con.getOutputStream().write(runtimeToken.getBytes());
                    Response response = ConnectionManager.this.retrieveRuntimeToken(con);
                    return response;
                }
                finally {
                    PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(startTime));
                    con.disconnect();
                }
            }
        }, "refreshRuntimeToken", 3, 100L);
        if (!result.successful()) {
            throw new CRSException(this.client, -2, "Cannot refresh runtime token: ", result);
        }
        return result.getResponse().getPayload();
    }

    public String getVmId() {
        return this.vmId;
    }

    public String getMailbox() {
        return this.mailbox;
    }

    public String getRestAPI() {
        return this.restAPI;
    }

    @FunctionalInterface
    public static interface ResponseSupplier {
        public Response<String[]> get() throws IOException;
    }

    private static interface ConnectionConsumer {
        public void consume(HttpsURLConnection var1) throws IOException;
    }

    static interface ConnectionListener {
        public void authenticated();

        public void syncFailed(Result<String[]> var1);
    }
}

